<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class VarientController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/varientlist[/{id}]", [PermissionMiddleware::class], "list.varient")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VarientList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/varientadd[/{id}]", [PermissionMiddleware::class], "add.varient")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VarientAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/varientview[/{id}]", [PermissionMiddleware::class], "view.varient")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VarientView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/varientedit[/{id}]", [PermissionMiddleware::class], "edit.varient")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VarientEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/varientdelete[/{id}]", [PermissionMiddleware::class], "delete.varient")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VarientDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/varientsearch", [PermissionMiddleware::class], "search.varient")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VarientSearch");
    }
}
