<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class UserController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/userlist[/{id}]", [PermissionMiddleware::class], "list.user")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/useradd[/{id}]", [PermissionMiddleware::class], "add.user")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/userview[/{id}]", [PermissionMiddleware::class], "view.user")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/useredit[/{id}]", [PermissionMiddleware::class], "edit.user")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/userdelete[/{id}]", [PermissionMiddleware::class], "delete.user")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/usersearch", [PermissionMiddleware::class], "search.user")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserSearch");
    }
}
