<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class UpdateOldPaymentController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/updateoldpaymentlist[/{id}]", [PermissionMiddleware::class], "list.update_old_payment")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UpdateOldPaymentList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/updateoldpaymentadd[/{id}]", [PermissionMiddleware::class], "add.update_old_payment")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UpdateOldPaymentAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/updateoldpaymentview[/{id}]", [PermissionMiddleware::class], "view.update_old_payment")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UpdateOldPaymentView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/updateoldpaymentedit[/{id}]", [PermissionMiddleware::class], "edit.update_old_payment")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UpdateOldPaymentEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/updateoldpaymentdelete[/{id}]", [PermissionMiddleware::class], "delete.update_old_payment")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UpdateOldPaymentDelete");
    }
}
