<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class UnitController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/unitlist[/{id}]", [PermissionMiddleware::class], "list.unit")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UnitList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/unitadd[/{id}]", [PermissionMiddleware::class], "add.unit")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UnitAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/unitview[/{id}]", [PermissionMiddleware::class], "view.unit")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UnitView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/unitedit[/{id}]", [PermissionMiddleware::class], "edit.unit")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UnitEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/unitdelete[/{id}]", [PermissionMiddleware::class], "delete.unit")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UnitDelete");
    }
}
