<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TmpNotesBcController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/tmpnotesbclist[/{id}]", [PermissionMiddleware::class], "list.tmp_notes_bc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TmpNotesBcList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/tmpnotesbcadd[/{id}]", [PermissionMiddleware::class], "add.tmp_notes_bc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TmpNotesBcAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/tmpnotesbcedit[/{id}]", [PermissionMiddleware::class], "edit.tmp_notes_bc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TmpNotesBcEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/tmpnotesbcdelete[/{id}]", [PermissionMiddleware::class], "delete.tmp_notes_bc")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TmpNotesBcDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/tmpnotesbcsearch", [PermissionMiddleware::class], "search.tmp_notes_bc")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TmpNotesBcSearch");
    }
}
