<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TestReportHeadController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/testreportheadlist[/{id}]", [PermissionMiddleware::class], "list.test_report_head")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportHeadList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/testreportheadadd[/{id}]", [PermissionMiddleware::class], "add.test_report_head")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportHeadAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/testreportheadview[/{id}]", [PermissionMiddleware::class], "view.test_report_head")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportHeadView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/testreportheadedit[/{id}]", [PermissionMiddleware::class], "edit.test_report_head")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportHeadEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/testreportheaddelete[/{id}]", [PermissionMiddleware::class], "delete.test_report_head")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportHeadDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/testreportheadsearch", [PermissionMiddleware::class], "search.test_report_head")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportHeadSearch");
    }
}
