<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TestReportGController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/testreportglist[/{id}]", [PermissionMiddleware::class], "list.test_report_g")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportGList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/testreportgadd[/{id}]", [PermissionMiddleware::class], "add.test_report_g")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportGAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/testreportgview[/{id}]", [PermissionMiddleware::class], "view.test_report_g")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportGView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/testreportgedit[/{id}]", [PermissionMiddleware::class], "edit.test_report_g")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportGEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/testreportgsearch", [PermissionMiddleware::class], "search.test_report_g")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportGSearch");
    }
}
