<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TestReportController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/testreportlist[/{id}]", [PermissionMiddleware::class], "list.test_report")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/testreportadd[/{id}]", [PermissionMiddleware::class], "add.test_report")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/testreportview[/{id}]", [PermissionMiddleware::class], "view.test_report")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/testreportedit[/{id}]", [PermissionMiddleware::class], "edit.test_report")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/testreportsearch", [PermissionMiddleware::class], "search.test_report")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TestReportSearch");
    }
}
