<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TaxCategoryController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/taxcategorylist[/{id}]", [PermissionMiddleware::class], "list.tax_category")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TaxCategoryList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/taxcategoryadd[/{id}]", [PermissionMiddleware::class], "add.tax_category")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TaxCategoryAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/taxcategoryaddopt", [PermissionMiddleware::class], "addopt.tax_category")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TaxCategoryAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/taxcategoryview[/{id}]", [PermissionMiddleware::class], "view.tax_category")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TaxCategoryView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/taxcategoryedit[/{id}]", [PermissionMiddleware::class], "edit.tax_category")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TaxCategoryEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/taxcategorydelete[/{id}]", [PermissionMiddleware::class], "delete.tax_category")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TaxCategoryDelete");
    }
}
