<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TTyreMaintenanceController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/ttyremaintenancelist[/{id}]", [PermissionMiddleware::class], "list.t_tyre_maintenance")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTyreMaintenanceList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/ttyremaintenanceadd[/{id}]", [PermissionMiddleware::class], "add.t_tyre_maintenance")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTyreMaintenanceAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/ttyremaintenanceview[/{id}]", [PermissionMiddleware::class], "view.t_tyre_maintenance")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTyreMaintenanceView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/ttyremaintenanceedit[/{id}]", [PermissionMiddleware::class], "edit.t_tyre_maintenance")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTyreMaintenanceEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/ttyremaintenancedelete[/{id}]", [PermissionMiddleware::class], "delete.t_tyre_maintenance")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTyreMaintenanceDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/ttyremaintenancesearch", [PermissionMiddleware::class], "search.t_tyre_maintenance")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTyreMaintenanceSearch");
    }
}
