<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TTyreInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/ttyreinfolist[/{id}]", [PermissionMiddleware::class], "list.t_tyre_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTyreInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/ttyreinfoadd[/{id}]", [PermissionMiddleware::class], "add.t_tyre_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTyreInfoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/ttyreinfoview[/{id}]", [PermissionMiddleware::class], "view.t_tyre_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTyreInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/ttyreinfoedit[/{id}]", [PermissionMiddleware::class], "edit.t_tyre_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTyreInfoEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/ttyreinfodelete[/{id}]", [PermissionMiddleware::class], "delete.t_tyre_info")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTyreInfoDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/ttyreinfosearch", [PermissionMiddleware::class], "search.t_tyre_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTyreInfoSearch");
    }
}
