<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TTripInfoDUnloadController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/ttripinfodunloadlist[/{id}]", [PermissionMiddleware::class], "list.t_trip_info_d_unload")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripInfoDUnloadList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/ttripinfodunloadview[/{id}]", [PermissionMiddleware::class], "view.t_trip_info_d_unload")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripInfoDUnloadView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/ttripinfodunloadedit[/{id}]", [PermissionMiddleware::class], "edit.t_trip_info_d_unload")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripInfoDUnloadEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/ttripinfodunloadsearch", [PermissionMiddleware::class], "search.t_trip_info_d_unload")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripInfoDUnloadSearch");
    }
}
