<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TTripInfoDController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/ttripinfodlist[/{id}]", [PermissionMiddleware::class], "list.t_trip_info_d")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripInfoDList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/ttripinfodview[/{id}]", [PermissionMiddleware::class], "view.t_trip_info_d")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripInfoDView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/ttripinfodedit[/{id}]", [PermissionMiddleware::class], "edit.t_trip_info_d")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripInfoDEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/ttripinfoddelete[/{id}]", [PermissionMiddleware::class], "delete.t_trip_info_d")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripInfoDDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/ttripinfodsearch", [PermissionMiddleware::class], "search.t_trip_info_d")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripInfoDSearch");
    }
}
