<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TTripInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/ttripinfolist[/{id}]", [PermissionMiddleware::class], "list.t_trip_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/ttripinfoadd[/{id}]", [PermissionMiddleware::class], "add.t_trip_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripInfoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/ttripinfoview[/{id}]", [PermissionMiddleware::class], "view.t_trip_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/ttripinfoedit[/{id}]", [PermissionMiddleware::class], "edit.t_trip_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripInfoEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/ttripinfosearch", [PermissionMiddleware::class], "search.t_trip_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripInfoSearch");
    }
}
