<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TTripBuyerController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/ttripbuyerlist[/{id}]", [PermissionMiddleware::class], "list.t_trip_buyer")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripBuyerList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/ttripbuyerview[/{id}]", [PermissionMiddleware::class], "view.t_trip_buyer")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripBuyerView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/ttripbuyersearch", [PermissionMiddleware::class], "search.t_trip_buyer")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TTripBuyerSearch");
    }
}
