<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TRouteInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/trouteinfolist[/{id}]", [PermissionMiddleware::class], "list.t_route_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TRouteInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/trouteinfoadd[/{id}]", [PermissionMiddleware::class], "add.t_route_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TRouteInfoAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/trouteinfoaddopt", [PermissionMiddleware::class], "addopt.t_route_info")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TRouteInfoAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/trouteinfoview[/{id}]", [PermissionMiddleware::class], "view.t_route_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TRouteInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/trouteinfoedit[/{id}]", [PermissionMiddleware::class], "edit.t_route_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TRouteInfoEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/trouteinfodelete[/{id}]", [PermissionMiddleware::class], "delete.t_route_info")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TRouteInfoDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/trouteinfosearch", [PermissionMiddleware::class], "search.t_route_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TRouteInfoSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/trouteinfopreview", [PermissionMiddleware::class], "preview.t_route_info")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TRouteInfoPreview", null, false);
    }
}
