<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TReceiptDController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/treceiptdlist[/{id}]", [PermissionMiddleware::class], "list.t_receipt_d")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TReceiptDList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/treceiptdadd[/{id}]", [PermissionMiddleware::class], "add.t_receipt_d")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TReceiptDAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/treceiptdview[/{id}]", [PermissionMiddleware::class], "view.t_receipt_d")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TReceiptDView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/treceiptdedit[/{id}]", [PermissionMiddleware::class], "edit.t_receipt_d")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TReceiptDEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/treceiptddelete[/{id}]", [PermissionMiddleware::class], "delete.t_receipt_d")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TReceiptDDelete");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/treceiptdpreview", [PermissionMiddleware::class], "preview.t_receipt_d")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TReceiptDPreview", null, false);
    }
}
