<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TReceiptBulkController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/treceiptbulklist[/{id}]", [PermissionMiddleware::class], "list.t_receipt_bulk")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TReceiptBulkList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/treceiptbulkadd[/{id}]", [PermissionMiddleware::class], "add.t_receipt_bulk")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TReceiptBulkAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/treceiptbulkview[/{id}]", [PermissionMiddleware::class], "view.t_receipt_bulk")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TReceiptBulkView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/treceiptbulkedit[/{id}]", [PermissionMiddleware::class], "edit.t_receipt_bulk")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TReceiptBulkEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/treceiptbulkdelete[/{id}]", [PermissionMiddleware::class], "delete.t_receipt_bulk")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TReceiptBulkDelete");
    }
}
