<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TPaymentController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/tpaymentlist[/{id}]", [PermissionMiddleware::class], "list.t_payment")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TPaymentList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/tpaymentadd[/{id}]", [PermissionMiddleware::class], "add.t_payment")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TPaymentAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/tpaymentview[/{id}]", [PermissionMiddleware::class], "view.t_payment")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TPaymentView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/tpaymentedit[/{id}]", [PermissionMiddleware::class], "edit.t_payment")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TPaymentEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/tpaymentdelete[/{id}]", [PermissionMiddleware::class], "delete.t_payment")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TPaymentDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/tpaymentsearch", [PermissionMiddleware::class], "search.t_payment")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TPaymentSearch");
    }
}
