<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TPaymentBulkController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/tpaymentbulklist[/{id}]", [PermissionMiddleware::class], "list.t_payment_bulk")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TPaymentBulkList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/tpaymentbulkadd[/{id}]", [PermissionMiddleware::class], "add.t_payment_bulk")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TPaymentBulkAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/tpaymentbulkview[/{id}]", [PermissionMiddleware::class], "view.t_payment_bulk")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TPaymentBulkView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/tpaymentbulkedit[/{id}]", [PermissionMiddleware::class], "edit.t_payment_bulk")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TPaymentBulkEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/tpaymentbulkdelete[/{id}]", [PermissionMiddleware::class], "delete.t_payment_bulk")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TPaymentBulkDelete");
    }
}
