<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TMaintenanceInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceinfolist[/{id}]", [PermissionMiddleware::class], "list.t_maintenance_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceinfoadd[/{id}]", [PermissionMiddleware::class], "add.t_maintenance_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceInfoAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceinfoaddopt", [PermissionMiddleware::class], "addopt.t_maintenance_info")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceInfoAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceinfoview[/{id}]", [PermissionMiddleware::class], "view.t_maintenance_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceinfoedit[/{id}]", [PermissionMiddleware::class], "edit.t_maintenance_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceInfoEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceinfodelete[/{id}]", [PermissionMiddleware::class], "delete.t_maintenance_info")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceInfoDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceinfosearch", [PermissionMiddleware::class], "search.t_maintenance_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceInfoSearch");
    }
}
