<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TMaintenanceExpController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceexplist[/{id}]", [PermissionMiddleware::class], "list.t_maintenance_exp")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceExpList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceexpadd[/{id}]", [PermissionMiddleware::class], "add.t_maintenance_exp")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceExpAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceexpview[/{id}]", [PermissionMiddleware::class], "view.t_maintenance_exp")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceExpView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceexpedit[/{id}]", [PermissionMiddleware::class], "edit.t_maintenance_exp")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceExpEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceexpdelete[/{id}]", [PermissionMiddleware::class], "delete.t_maintenance_exp")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceExpDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceexpsearch", [PermissionMiddleware::class], "search.t_maintenance_exp")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceExpSearch");
    }
}
