<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TMaintenanceController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/tmaintenancelist[/{id}]", [PermissionMiddleware::class], "list.t_maintenance")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceadd[/{id}]", [PermissionMiddleware::class], "add.t_maintenance")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceview[/{id}]", [PermissionMiddleware::class], "view.t_maintenance")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/tmaintenanceedit[/{id}]", [PermissionMiddleware::class], "edit.t_maintenance")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/tmaintenancedelete[/{id}]", [PermissionMiddleware::class], "delete.t_maintenance")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/tmaintenancesearch", [PermissionMiddleware::class], "search.t_maintenance")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TMaintenanceSearch");
    }
}
