<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TFasttagExpensesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/tfasttagexpenseslist[/{id}]", [PermissionMiddleware::class], "list.t_fasttag_expenses")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TFasttagExpensesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/tfasttagexpensesadd[/{id}]", [PermissionMiddleware::class], "add.t_fasttag_expenses")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TFasttagExpensesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/tfasttagexpensesview[/{id}]", [PermissionMiddleware::class], "view.t_fasttag_expenses")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TFasttagExpensesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/tfasttagexpensesedit[/{id}]", [PermissionMiddleware::class], "edit.t_fasttag_expenses")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TFasttagExpensesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/tfasttagexpensesdelete[/{id}]", [PermissionMiddleware::class], "delete.t_fasttag_expenses")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TFasttagExpensesDelete");
    }
}
