<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TExpensesOController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/texpensesolist[/{id}]", [PermissionMiddleware::class], "list.t_expenses_o")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesOList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/texpensesoadd[/{id}]", [PermissionMiddleware::class], "add.t_expenses_o")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesOAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/texpensesoview[/{id}]", [PermissionMiddleware::class], "view.t_expenses_o")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesOView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/texpensesoedit[/{id}]", [PermissionMiddleware::class], "edit.t_expenses_o")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesOEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/texpensesodelete[/{id}]", [PermissionMiddleware::class], "delete.t_expenses_o")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesODelete");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/texpensesopreview", [PermissionMiddleware::class], "preview.t_expenses_o")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesOPreview", null, false);
    }
}
