<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TExpensesInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/texpensesinfolist[/{id}]", [PermissionMiddleware::class], "list.t_expenses_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/texpensesinfoadd[/{id}]", [PermissionMiddleware::class], "add.t_expenses_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesInfoAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/texpensesinfoaddopt", [PermissionMiddleware::class], "addopt.t_expenses_info")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesInfoAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/texpensesinfoview[/{id}]", [PermissionMiddleware::class], "view.t_expenses_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/texpensesinfoedit[/{id}]", [PermissionMiddleware::class], "edit.t_expenses_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesInfoEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/texpensesinfodelete[/{id}]", [PermissionMiddleware::class], "delete.t_expenses_info")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesInfoDelete");
    }
}
