<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TExpensesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/texpenseslist[/{id}]", [PermissionMiddleware::class], "list.t_expenses")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/texpensesadd[/{id}]", [PermissionMiddleware::class], "add.t_expenses")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/texpensesview[/{id}]", [PermissionMiddleware::class], "view.t_expenses")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/texpensesedit[/{id}]", [PermissionMiddleware::class], "edit.t_expenses")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesEdit");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/texpensespreview", [PermissionMiddleware::class], "preview.t_expenses")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TExpensesPreview", null, false);
    }
}
