<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TDriverInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/tdriverinfolist[/{id}]", [PermissionMiddleware::class], "list.t_driver_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDriverInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/tdriverinfoadd[/{id}]", [PermissionMiddleware::class], "add.t_driver_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDriverInfoAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/tdriverinfoaddopt", [PermissionMiddleware::class], "addopt.t_driver_info")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDriverInfoAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/tdriverinfoview[/{id}]", [PermissionMiddleware::class], "view.t_driver_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDriverInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/tdriverinfoedit[/{id}]", [PermissionMiddleware::class], "edit.t_driver_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDriverInfoEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/tdriverinfosearch", [PermissionMiddleware::class], "search.t_driver_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDriverInfoSearch");
    }
}
