<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TDiesalExpensesDController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/tdiesalexpensesdlist[/{id}]", [PermissionMiddleware::class], "list.t_diesal_expenses_d")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDiesalExpensesDList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/tdiesalexpensesdadd[/{id}]", [PermissionMiddleware::class], "add.t_diesal_expenses_d")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDiesalExpensesDAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/tdiesalexpensesdview[/{id}]", [PermissionMiddleware::class], "view.t_diesal_expenses_d")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDiesalExpensesDView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/tdiesalexpensesdedit[/{id}]", [PermissionMiddleware::class], "edit.t_diesal_expenses_d")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDiesalExpensesDEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/tdiesalexpensesddelete[/{id}]", [PermissionMiddleware::class], "delete.t_diesal_expenses_d")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDiesalExpensesDDelete");
    }
}
