<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TDiesalExpensesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/tdiesalexpenseslist[/{id}]", [PermissionMiddleware::class], "list.t_diesal_expenses")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDiesalExpensesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/tdiesalexpensesadd[/{id}]", [PermissionMiddleware::class], "add.t_diesal_expenses")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDiesalExpensesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/tdiesalexpensesview[/{id}]", [PermissionMiddleware::class], "view.t_diesal_expenses")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDiesalExpensesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/tdiesalexpensesedit[/{id}]", [PermissionMiddleware::class], "edit.t_diesal_expenses")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDiesalExpensesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/tdiesalexpensesdelete[/{id}]", [PermissionMiddleware::class], "delete.t_diesal_expenses")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDiesalExpensesDelete");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/tdiesalexpensespreview", [PermissionMiddleware::class], "preview.t_diesal_expenses")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDiesalExpensesPreview", null, false);
    }
}
