<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class TDailyKmController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/tdailykmlist[/{id}]", [PermissionMiddleware::class], "list.t_daily_km")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDailyKmList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/tdailykmadd[/{id}]", [PermissionMiddleware::class], "add.t_daily_km")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDailyKmAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/tdailykmview[/{id}]", [PermissionMiddleware::class], "view.t_daily_km")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDailyKmView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/tdailykmedit[/{id}]", [PermissionMiddleware::class], "edit.t_daily_km")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDailyKmEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/tdailykmdelete[/{id}]", [PermissionMiddleware::class], "delete.t_daily_km")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDailyKmDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/tdailykmsearch", [PermissionMiddleware::class], "search.t_daily_km")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TDailyKmSearch");
    }
}
