<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class StockLcgpdController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/stocklcgpdlist", [PermissionMiddleware::class], "list.stock_lcgpd")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockLcgpdList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/stocklcgpdsearch", [PermissionMiddleware::class], "search.stock_lcgpd")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockLcgpdSearch");
    }
}
