<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class StockLcgpController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/stocklcgplist", [PermissionMiddleware::class], "list.stock_lcgp")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockLcgpList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/stocklcgpsearch", [PermissionMiddleware::class], "search.stock_lcgp")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockLcgpSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/stocklcgppreview", [PermissionMiddleware::class], "preview.stock_lcgp")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockLcgpPreview", null, false);
    }
}
