<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class StockGodownTransferController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/stockgodowntransferlist", [PermissionMiddleware::class], "list.stock_godown_transfer")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockGodownTransferList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/stockgodowntransfersearch", [PermissionMiddleware::class], "search.stock_godown_transfer")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockGodownTransferSearch");
    }
}
