<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class StockController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/stocklist", [PermissionMiddleware::class], "list.stock")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/stocksearch", [PermissionMiddleware::class], "search.stock")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/stockpreview", [PermissionMiddleware::class], "preview.stock")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockPreview", null, false);
    }
}
