<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class StockConsumeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/stockconsumelist[/{id}]", [PermissionMiddleware::class], "list.stock_consume")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockConsumeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/stockconsumeadd[/{id}]", [PermissionMiddleware::class], "add.stock_consume")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockConsumeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/stockconsumeview[/{id}]", [PermissionMiddleware::class], "view.stock_consume")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockConsumeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/stockconsumeedit[/{id}]", [PermissionMiddleware::class], "edit.stock_consume")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockConsumeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/stockconsumedelete[/{id}]", [PermissionMiddleware::class], "delete.stock_consume")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StockConsumeDelete");
    }
}
