<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class StatusController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/statuslist[/{id}]", [PermissionMiddleware::class], "list.status")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StatusList");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/statusedit[/{id}]", [PermissionMiddleware::class], "edit.status")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StatusEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/statussearch", [PermissionMiddleware::class], "search.status")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StatusSearch");
    }
}
