<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class StaticPagesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/staticpageslist[/{id}]", [PermissionMiddleware::class], "list.static_pages")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StaticPagesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/staticpagesadd[/{id}]", [PermissionMiddleware::class], "add.static_pages")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StaticPagesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/staticpagesview[/{id}]", [PermissionMiddleware::class], "view.static_pages")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StaticPagesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/staticpagesedit[/{id}]", [PermissionMiddleware::class], "edit.static_pages")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StaticPagesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/staticpagesdelete[/{id}]", [PermissionMiddleware::class], "delete.static_pages")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "StaticPagesDelete");
    }
}
