<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SpecialTaskController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/specialtasklist[/{id}]", [PermissionMiddleware::class], "list.special_task")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SpecialTaskList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/specialtaskadd[/{id}]", [PermissionMiddleware::class], "add.special_task")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SpecialTaskAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/specialtaskview[/{id}]", [PermissionMiddleware::class], "view.special_task")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SpecialTaskView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/specialtaskedit[/{id}]", [PermissionMiddleware::class], "edit.special_task")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SpecialTaskEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/specialtaskdelete[/{id}]", [PermissionMiddleware::class], "delete.special_task")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SpecialTaskDelete");
    }
}
