<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SpecialPermissionsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/specialpermissionslist[/{id}]", [PermissionMiddleware::class], "list.special_permissions")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SpecialPermissionsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/specialpermissionsadd[/{id}]", [PermissionMiddleware::class], "add.special_permissions")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SpecialPermissionsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/specialpermissionsview[/{id}]", [PermissionMiddleware::class], "view.special_permissions")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SpecialPermissionsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/specialpermissionsedit[/{id}]", [PermissionMiddleware::class], "edit.special_permissions")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SpecialPermissionsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/specialpermissionsdelete[/{id}]", [PermissionMiddleware::class], "delete.special_permissions")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SpecialPermissionsDelete");
    }
}
