<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SocialIconsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/socialiconslist[/{id}]", [PermissionMiddleware::class], "list.social_icons")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SocialIconsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/socialiconsadd[/{id}]", [PermissionMiddleware::class], "add.social_icons")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SocialIconsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/socialiconsview[/{id}]", [PermissionMiddleware::class], "view.social_icons")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SocialIconsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/socialiconsedit[/{id}]", [PermissionMiddleware::class], "edit.social_icons")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SocialIconsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/socialiconsdelete[/{id}]", [PermissionMiddleware::class], "delete.social_icons")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SocialIconsDelete");
    }
}
