<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SmsSetupController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/smssetuplist[/{id}]", [PermissionMiddleware::class], "list.sms_setup")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SmsSetupList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/smssetupadd[/{id}]", [PermissionMiddleware::class], "add.sms_setup")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SmsSetupAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/smssetupview[/{id}]", [PermissionMiddleware::class], "view.sms_setup")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SmsSetupView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/smssetupedit[/{id}]", [PermissionMiddleware::class], "edit.sms_setup")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SmsSetupEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/smssetupdelete[/{id}]", [PermissionMiddleware::class], "delete.sms_setup")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SmsSetupDelete");
    }
}
