<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SiteSearchController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/sitesearchlist[/{id}]", [PermissionMiddleware::class], "list.site_search")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SiteSearchList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/sitesearchadd[/{id}]", [PermissionMiddleware::class], "add.site_search")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SiteSearchAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/sitesearchview[/{id}]", [PermissionMiddleware::class], "view.site_search")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SiteSearchView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/sitesearchedit[/{id}]", [PermissionMiddleware::class], "edit.site_search")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SiteSearchEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/sitesearchdelete[/{id}]", [PermissionMiddleware::class], "delete.site_search")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SiteSearchDelete");
    }
}
