<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ShippingTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/shippingtypelist[/{id}]", [PermissionMiddleware::class], "list.shipping_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/shippingtypeadd[/{id}]", [PermissionMiddleware::class], "add.shipping_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingTypeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/shippingtypeview[/{id}]", [PermissionMiddleware::class], "view.shipping_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingTypeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/shippingtypeedit[/{id}]", [PermissionMiddleware::class], "edit.shipping_type")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingTypeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/shippingtypedelete[/{id}]", [PermissionMiddleware::class], "delete.shipping_type")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingTypeDelete");
    }
}
