<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ShippingLineController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/shippinglinelist[/{id}]", [PermissionMiddleware::class], "list.shipping_line")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingLineList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/shippinglineadd[/{id}]", [PermissionMiddleware::class], "add.shipping_line")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingLineAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/shippinglineaddopt", [PermissionMiddleware::class], "addopt.shipping_line")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingLineAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/shippinglineview[/{id}]", [PermissionMiddleware::class], "view.shipping_line")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingLineView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/shippinglineedit[/{id}]", [PermissionMiddleware::class], "edit.shipping_line")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingLineEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/shippinglinedelete[/{id}]", [PermissionMiddleware::class], "delete.shipping_line")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingLineDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/shippinglinesearch", [PermissionMiddleware::class], "search.shipping_line")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingLineSearch");
    }
}
