<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ShippingDetailsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/shippingdetailslist[/{id}]", [PermissionMiddleware::class], "list.shipping_details")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingDetailsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/shippingdetailsadd[/{id}]", [PermissionMiddleware::class], "add.shipping_details")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingDetailsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/shippingdetailsview[/{id}]", [PermissionMiddleware::class], "view.shipping_details")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingDetailsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/shippingdetailsedit[/{id}]", [PermissionMiddleware::class], "edit.shipping_details")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingDetailsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/shippingdetailsdelete[/{id}]", [PermissionMiddleware::class], "delete.shipping_details")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingDetailsDelete");
    }
}
