<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ShippingAddressController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/shippingaddresslist[/{id}]", [PermissionMiddleware::class], "list.shipping_address")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingAddressList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/shippingaddressadd[/{id}]", [PermissionMiddleware::class], "add.shipping_address")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingAddressAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/shippingaddressaddopt", [PermissionMiddleware::class], "addopt.shipping_address")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingAddressAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/shippingaddressview[/{id}]", [PermissionMiddleware::class], "view.shipping_address")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingAddressView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/shippingaddressedit[/{id}]", [PermissionMiddleware::class], "edit.shipping_address")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingAddressEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/shippingaddressdelete[/{id}]", [PermissionMiddleware::class], "delete.shipping_address")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingAddressDelete");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/shippingaddresspreview", [PermissionMiddleware::class], "preview.shipping_address")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShippingAddressPreview", null, false);
    }
}
