<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ShareTransferController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/sharetransferlist[/{id}]", [PermissionMiddleware::class], "list.share_transfer")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShareTransferList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/sharetransferadd[/{id}]", [PermissionMiddleware::class], "add.share_transfer")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShareTransferAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/sharetransferview[/{id}]", [PermissionMiddleware::class], "view.share_transfer")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShareTransferView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/sharetransfersearch", [PermissionMiddleware::class], "search.share_transfer")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShareTransferSearch");
    }
}
