<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ShapeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/shapelist[/{id}]", [PermissionMiddleware::class], "list.shape")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShapeList");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/shapeedit[/{id}]", [PermissionMiddleware::class], "edit.shape")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShapeEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/shapesearch", [PermissionMiddleware::class], "search.shape")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShapeSearch");
    }
}
