<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ShadeTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/shadetypelist[/{id}]", [PermissionMiddleware::class], "list.shade_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShadeTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/shadetypeadd[/{id}]", [PermissionMiddleware::class], "add.shade_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShadeTypeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/shadetypeview[/{id}]", [PermissionMiddleware::class], "view.shade_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShadeTypeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/shadetypeedit[/{id}]", [PermissionMiddleware::class], "edit.shade_type")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ShadeTypeEdit");
    }
}
